<?php

class EWRporta_Model_Parser extends XenForo_Model
{
	public function parseSidebar($page)
	{
		if (preg_match('/\[SIDEBAR\]/i', $page['HTML']))
		{
			$page['HTML'] = preg_replace('/\[SIDEBAR\]/i', '', $page['HTML']);
			$page['sidebar'] = true;
		}
		else
		{
			$page['sidebar'] = false;
		}

		return $page;
	}

	public function parseContents($page)
	{
		$page['HTML'] = preg_replace('/\[h(\d+)\](.*?)\[\/h(\d+)\]/i', '<h$1>$2</h$1>', $page['HTML']);
		$page['HTML'] = preg_replace('/<\/h(\d+)><br \/>/i', '</h$1>', $page['HTML']);

		$headPattern = '/<h(\d+)>(.*?)<\/h\d+>/i';

		if (preg_match_all($headPattern, $page['HTML'], $headMatches))
		{
			$anchor = 0;
			$contents = '';

			foreach ($headMatches[0] AS $key => $headMatch)
			{
				$anchor++;

				$pageLink = XenForo_Link::buildPublicLink('full:wiki', $page);

				$headCode = $headMatches[0][$key];
				$headType = $headMatches[1][$key];
				$headName = $headMatches[2][$key];

				$headSlug = strtolower($headName);
				$headSlug = preg_replace('/[^a-z0-9\-\s]/', '', $headSlug);
				$headSlug = preg_replace('/\s+/', '-', $headSlug);
				$headSlug = preg_replace('/\-+/', '-', $headSlug);

				$headLink = '<h'.$headType.'><a name="'.$anchor.'-'.$headSlug.'">'.$headName.'</a></h'.$headType.'>';

				$indent = ($headType - 2) * 1.5;

				$contents .= '<li style="margin-left: '.$indent.'em"><a href="'.$pageLink.'#'.$anchor.'-'.$headSlug.'">'.$headMatches[2][$key].'</a></li>';

				$page['HTML'] = str_replace($headCode, $headLink, $page['HTML']);
			}

			$contents = '<h2>Contents</h2><ul>'.$contents.'</ul><br />';

			$page['TOC'] = '<ul>'.$contents.'</ul>';
			$page['HTML'] = preg_replace('/<h/i', $contents.'<h', $page['HTML'], 1);
		}

		return $page;
	}

	public function parseTemplates($page)
	{
		$templates = $this->fetchAllKeyed("
			SELECT *
				FROM EWRporta_templates
		", 'template_name');

		$codePattern = '/\[template=([A-Za-z0-9\-]+)\](.*?)\[\/template\]/si';
		$dataPattern = '/([\w\s]+)=(.+)/s';

		if (preg_match_all($codePattern, $page['HTML'], $codeMatches))
		{
			foreach ($codeMatches[0] AS $key => $codeMatch)
			{
				$originalCode = $codeMatches[0][$key];
				$templateCode = strtolower($codeMatches[1][$key]);
				$variableCode = $codeMatches[2][$key];

				if (isset($templates[$templateCode]))
				{
					$matches = explode("|", $variableCode);
					$replaceText = $templates[$templateCode]['template_content'];

					foreach ($matches AS $match)
					{
						if (preg_match($dataPattern, $match, $dataMatch))
						{
							$vname = trim($dataMatch[1]);
							$value = trim($dataMatch[2]);

							$value = preg_replace('/<br \/>$/i', "", $value);

							$replaceText = str_replace("{{{".$vname."}}}", $value, $replaceText);
						}
					}

					$page['HTML'] = str_replace($originalCode."<br />", $originalCode, $page['HTML']);	
					$page['HTML'] = str_replace($originalCode, $replaceText, $page['HTML']);
				}
			}
		}

		return $page;
	}

	public function parseAutolinks($page)
	{
		if (isset($page['page_name']))
		{
			$allPages = $this->_getDb()->fetchAll("
				SELECT *
					FROM EWRporta_pages
				WHERE page_name != ?
			", $page['page_name']);

			foreach ($allPages AS $allPage)
			{
				$linkURL = XenForo_Link::buildPublicLink('full:wiki', $allPage);
				$linkText = '<a href="'.$linkURL.'">'.$allPage['page_name'].'</a>';

				$page['HTML'] = preg_replace('/('.$allPage['page_name'].')(?=[^>]*?<)/si', $linkText, $page['HTML']);
			}
		}

		return $page;
	}
}